#ifndef MACS_THREAD_LABELS_H
#define MACS_THREAD_LABELS_H

#include <string>
#include <vector>
#include <macs/types.h>
#include <macs/revision.h>

namespace macs
{

#define GETTER(NAME,FIELD,TYPE) \
    TYPE NAME () const { \
        return FIELD##_; \
    }

class ThreadLabels {
public:

    class TLabel {
    public:
        TLabel(const std::string & lid, unsigned int cnt)
            : lid_(lid), cnt_(cnt)
        { }

        GETTER(lid,lid,const std::string &)
        GETTER(cnt,cnt,unsigned int)

    private:
        std::string lid_;
        unsigned int cnt_;
    };

    ThreadLabels(const std::string& tid, Revision tscn,
                 const std::vector<TLabel>& labels = std::vector<TLabel>())
        : tid_(tid), tscn_(tscn), labels_(labels)
    { }

    GETTER(tid,tid,const std::string &)
    GETTER(tscn,tscn,Revision)
    GETTER(labels,labels,const std::vector<TLabel> &)

private:
    std::string tid_;
    Revision tscn_;
    std::vector<TLabel> labels_;
};

#undef GETTER

struct ThreadLabelsFactory {

    using Label = ThreadLabels::TLabel;

    ThreadLabelsFactory()
        : revision(0)
    { }

    Revision currentRevision() const {
        return revision;
    }

    const ThreadId& currentTid() const {
        return tid;
    }

    ThreadLabelsFactory& reset() {
        tid = "";
        revision = 0;
        labels.clear();
        return *this;
    }

    ThreadLabelsFactory& setTid(const ThreadId& param) {
        tid = param;
        return *this;
    }

    ThreadLabelsFactory& setRevision(Revision param) {
        revision = param;
        return *this;
    }

    ThreadLabelsFactory& addLabel(const std::string& lid, unsigned int count) {
        labels.emplace_back(lid, count);
        return *this;
    }

    macs::ThreadLabels product() const {
        return macs::ThreadLabels(tid, revision, labels);
    }

private:
    ThreadId tid;
    Revision revision;
    std::vector<Label> labels;
};

typedef std::vector<ThreadLabels> ThreadLabelsList;

} // macs


#endif  /* __MACS_THREAD_LABELS_H */
