#pragma once

#include <vector>
#include <string>
#include <list>
#include <algorithm>
#include <macs/types.h>
#include <macs/label.h>
#include <boost/range/algorithm.hpp>

namespace macs {

struct ThreadMailboxItem {
    Mid mid;
    Fid fid;
    Tid threadId;
    bool seen;
    bool spam;
    std::string receivedDate;
    Stid stid;
    std::optional<Tab::Type> tab;
    Lids lidsToCheck;
};

typedef std::vector<ThreadMailboxItem> ThreadMailboxItems;

inline std::list<Mid> getMids(const ThreadMailboxItems& items) {
    std::list<Mid> mids;
    boost::transform(items, std::back_inserter(mids), [](auto& v){return v.mid;});
    return mids;
}

}
