/**
 * @file   thread_participants.h
 * @brief  Macs thread participants struct wrapper
 * @author Alexey Kremenkov
 * © Yandex LLC.
 */
#ifndef MACS_THREAD_PARTICIPANTS_H
#define MACS_THREAD_PARTICIPANTS_H

#include <string>
#include <vector>
#include <set>
#include <macs/types.h>
#include <butil/email/email.h>

namespace macs
{

#define GETTER_E(NAME,FIELD,TYPE) \
    TYPE NAME () const { \
        return FIELD##_; \
    }

/** @class ThreadParticipants
 *  @brief envelope for threads
 */
class ThreadParticipants {
public:

    /** @class Participant
     *  @brief Describes the thread participant
     */
    class Participant {
    public:
        typedef int MessageType;
        typedef std::set<MessageType> Types;

        Participant()
        {}

        Participant(const std::string & mid, const Email & from) {
            mid_ = mid;
            from_ = from;
        }

        GETTER_E(mid,mid,const std::string &)
        GETTER_E(from,from,const Email &)
        GETTER_E(types,types,const Types &)

        Participant& addType(MessageType type) {
            types_.insert(type);
            return *this;
        }

    private:
        std::string mid_;                              //!< message ID in the metabase
        Email from_;                                   //!< 'From' header
        Types types_;                                  //!< message types
    };

    ThreadParticipants(void)
    {}

    GETTER_E(threadId,threadId,const ThreadId &)
    GETTER_E(participants,participants,const std::vector<Participant> &)

private:
    ThreadId threadId_;                                 //!< ID of the thread
    std::vector<Participant> participants_;             //!< Thread participants

    friend class ThreadParticipantsFactory;
};

#undef GETTER_E

/// list of threads participants
typedef std::vector<ThreadParticipants> ThreadParticipantsList;

} // macs


#endif  /* __MACS_THREAD_PARTICIPANTS_H */

