/**
 * @file   thread_factory.h
 * @author Alexey Kremenkov
 * © Yandex LLC.
 */

#ifndef MACS_THREAD_PARTICIPANTS_FACTORY_H
#define MACS_THREAD_PARTICIPANTS_FACTORY_H

#include <macs/thread_participants.h>

namespace macs {

#define MODIFIER(NAME,FIELD,TYPE) \
    ThreadParticipantsFactory & NAME (TYPE NAME) { \
        threadParticipants.FIELD##_ = NAME; \
        return *this; \
    }

class ThreadParticipantsFactory {
public:
    ThreadParticipantsFactory() {}

    ThreadParticipantsFactory & newThreadParticipants() {
        threadParticipants = ThreadParticipants();
        return *this;
    }

    MODIFIER( threadId, threadId, const std::string &)

    ThreadParticipantsFactory & addParticipant(const ThreadParticipants::Participant & participant) {
        threadParticipants.participants_.push_back(participant);
        return *this;
    }

    bool existParticipant (const Email &email) const;

    const ThreadParticipants & product() const {
        return threadParticipants;
    }

    operator ThreadParticipants() const {
        return threadParticipants;
    }

private:
    ThreadParticipants threadParticipants;
    friend class ThreadsRepository;
};

}

#undef MODIFIER

#endif  /* __MACS_THREAD_PARTICIPANTS_FACTORY_H */
