#ifndef INCLUDE_MACS_THREADS_META_H_
#define INCLUDE_MACS_THREADS_META_H_

#include <cstdint>
#include <ctime>
#include <string>
#include <vector>

namespace macs {

using Hash = std::string; // тут должен быть uint64_t но postgress не умеет unsigned надо починить потом

enum class ThreadsMergeRules {
    hash,
    references,
    forceNewThread
};

enum class ThreadsHashNamespaces {
    subject,
    from
};

struct ThreadHash {
    ThreadsHashNamespaces ns = ThreadsHashNamespaces::subject;
    Hash value = "0";
    Hash key = "0";
};

struct ThreadLimits {
    std::time_t receivedDate = 0;
    unsigned int daysLimit = 0;
    unsigned int countLimit = 0;
};

struct ThreadMeta {
    ThreadHash hash;
    ThreadLimits limits;
    ThreadsMergeRules mergeRule = ThreadsMergeRules::forceNewThread;
    std::vector<Hash> referenceHashes;
    std::vector<std::string> messageIds;
    Hash inReplyToHash;
    Hash messageIdHash;
    std::string sortOptions;
};

} // namespace macs

#endif /* INCLUDE_MACS_THREADS_META_H_ */
