#pragma once

#include <boost/any.hpp>
#include <boost/fusion/adapted/std_pair.hpp>
#include <macs/error_code.h>
#include <string>
#include <vector>
#include <chrono>
#include <memory>
#include <vector>
#include <list>

namespace macs {

constexpr int ENUM_ERROR_STARTING_VALUE = 1;

using Uid = std::string;
using Mid = std::string;
using MidList = std::list<Mid>;
typedef std::list<Mid> Mids;
typedef std::vector<Mid> MidVec;

using RfcMessageId = std::string;
using ImapId = std::string;

using HdrDateAndMessageId = std::pair<time_t, RfcMessageId>;
using HdrDateAndMessageIdVec = std::vector<HdrDateAndMessageId>;

typedef std::string MailRef;
typedef std::vector<MailRef> MailRefVec;

using Stid = std::string;

struct MidAndImapId {
    Mid mid;
    ImapId imapId;

    MidAndImapId(Mid mid, ImapId imapId)
        : mid(std::move(mid)), imapId(std::move(imapId))
    { }
};

using MidAndImapIdVec = std::vector<MidAndImapId>;

struct MidStid {
    Mid mid;
    Stid stid;

    MidStid() = default;
    MidStid(const Mid& mid, const Stid& stid) : mid(mid), stid(stid) {}
};

typedef std::vector<MidStid> MidsWithStids;

typedef std::string ThreadId;
using Tid = ThreadId;
using TidList = std::list<Tid>;
using TidVector = std::vector<Tid>;
typedef TidVector Tids;

using Days = std::chrono::duration<int, std::ratio<60*60*24>>;

using Hid = std::string;

using FolderId = std::string;
using Fid = FolderId;
using FidVec = std::vector<Fid>;
typedef std::vector<Fid> Pop3Folders;

using LabelId = std::string;
using Lid = LabelId;
using Lids = std::vector<Lid>;


struct StickerAllowedInterval {
    std::time_t min;
    std::time_t max;
};


}
