#ifndef USER_JOURNAL_H_125902072013
#define USER_JOURNAL_H_125902072013

#include <user_journal/journal.h>
#include <boost/shared_ptr.hpp>

namespace macs {

class UserJournal {
public:
    using Journal = user_journal::Journal;
    typedef user_journal::Operation Operation;

    UserJournal( Journal journal ) : journal_(std::move(journal)) {}

    virtual ~UserJournal() {}

    template<typename OperationType, typename... ArgsT>
    void logOperation(ArgsT&&... args) const {
        asyncGetShardName([journal = journal_, t = std::make_tuple(std::forward<ArgsT>(args)...)] (std::string shardName) mutable {
            using namespace user_journal::parameters;
            journal.write<OperationType>(id::mdb(std::move(shardName)), t);
        });
    }

protected:
    typedef std::function< void (std::string) > OnStringReceive;

    virtual void asyncGetShardName(OnStringReceive handler) const = 0;

private:
    Journal journal_;
};

typedef boost::shared_ptr<UserJournal> UserJournalPtr;

}

#endif /* USER_JOURNAL_H_125902072013 */
