/*
 * File:   wh_connection_info.h
 * © 2011 Yandex LLC.
 *
 */
#ifndef STUB_CONN_INFO_H
#define STUB_CONN_INFO_H

#include <memory>

#include <macs/data.h>
#include <macs/connection_info.h>

#include <string>

namespace macs {

/// stub connection info
struct stub_connection_info : public ConnectionInfo {

public:
    stub_connection_info() : ConnectionInfo() { }
    stub_connection_info ( const std::string & suid, const std::string & country,
            bool autocreate, const std::string & mdb = "")
        : ConnectionInfo ( suid, country, autocreate, mdb ) { }

    ConnectionInfoPtr clone() const;

    RepositoriesHolderPtr createRepositories() const;

};

}


#endif
