include(find_macs_dependencies)

if(MACS_INCLUDE_DIR AND MACS_LIBRARIES)
  set(MACS_FIND_QUIETLY TRUE)
endif()

find_path(MACS_INCLUDE_DIR
  NAMES macs/macs.h
  HINTS ${CMAKE_INSTALL_PREFIX}/include)

find_library(MACS_LIBRARY NAMES macs
  HINTS ${CMAKE_INSTALL_PREFIX}
  PATH_SUFFIXES .libs lib lib64)

find_macs_dependencies()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(MACS DEFAULT_MSG
  MACS_LIBRARY MACS_INCLUDE_DIR)

if(MACS_FOUND)
  list(APPEND MACS_INCLUDE_DIR ${MACS_DEPENDENCY_INCLUDE_DIRS})
  list(APPEND MACS_LIBRARIES ${MACS_LIBRARY} ${MACS_DEPENDENCY_LIBRARIES})
endif()

mark_as_advanced(MACS_INCLUDE_DIR MACS_LIBRARIES)
