#include <macs/archive_error.h>

namespace macs {

std::string ExchangeArchiveStateCategory::message(int v) const {
    using EnumType = ExchangeArchiveStateStatus;
    switch(EnumType(v)) {
        case EnumType::user_not_here:
            return "user is not here";
        case EnumType::user_wrong_state:
            return "user is in wrong state";
        case EnumType::archive_not_found:
            return "archive is not found or is in wrong state";
    }
    return "unknown enum code";
}

const ExchangeArchiveStateCategory& getExchangeArchiveStateCategory() {
    static ExchangeArchiveStateCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(ExchangeArchiveStateStatus e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getExchangeArchiveStateCategory());
}

mail_errors::error_code make_error(ExchangeArchiveStateStatus e) {
    return mail_errors::error_code(e);
}

}
