#include <macs/backup_error.h>

namespace macs {

std::string CreateBackupCategory::message(int v) const {
    switch(CreateBackupStatus(v)) {
        case CreateBackupStatus::empty_folder_list:
            return "empty folder list";
        case CreateBackupStatus::nothing_to_backup:
            return "nothing to backup";
        case CreateBackupStatus::too_many_messages:
            return "too many messages";
        case CreateBackupStatus::running_restore:
            return "running restore";
        case CreateBackupStatus::unique_violation:
            return "unique violation";
        case CreateBackupStatus::backup_id_not_reserved:
            return "backup_id is not reserved";
    }
    return "unknown enum code";
}

const CreateBackupCategory& getCreateBackupCategory() {
    static CreateBackupCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(CreateBackupStatus e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getCreateBackupCategory());
}

mail_errors::error_code make_error(CreateBackupStatus e) {
    return mail_errors::error_code(e);
}

std::string RestoreBackupCategory::message(int v) const {
    switch(RestoreBackupStatus(v)) {
        case RestoreBackupStatus::unique_violation:
            return "unique violation";
        case RestoreBackupStatus::backup_is_missing:
            return "backup is missing";
        case RestoreBackupStatus::wrong_state:
            return "wrong state";
        case RestoreBackupStatus::another_backup_is_running:
            return "another backup is running";
    }
    return "unknown enum code";
}

const RestoreBackupCategory& getRestoreBackupCategory() {
    static RestoreBackupCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(RestoreBackupStatus e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getRestoreBackupCategory());
}

mail_errors::error_code make_error(RestoreBackupStatus e) {
    return mail_errors::error_code(e);
}

std::string FillBackupCategory::message(int v) const {
    switch(FillBackupStatus(v)) {
        case FillBackupStatus::wrong_state:
            return "wrong state";
        case FillBackupStatus::nothing_to_backup:
            return "nothing to backup";
        case FillBackupStatus::backup_is_missing:
            return "backup is missing";
    }
    return "unknown enum code";
}

const FillBackupCategory& getFillBackupCategory() {
    static FillBackupCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(FillBackupStatus e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getFillBackupCategory());
}

mail_errors::error_code make_error(FillBackupStatus e) {
    return mail_errors::error_code(e);
}

std::string DeactivateBackupCategory::message(int v) const {
    switch(DeactivateBackupStatus(v)) {
        case DeactivateBackupStatus::restore_in_progress:
            return "restore in progress";
        case DeactivateBackupStatus::missing_complete_backup:
            return "missing complete backup";
    }
    return "unknown enum code";
}

const DeactivateBackupCategory& getDeactivateBackupCategory() {
    static DeactivateBackupCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(DeactivateBackupStatus e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getDeactivateBackupCategory());
}

mail_errors::error_code make_error(DeactivateBackupStatus e) {
    return mail_errors::error_code(e);
}

}
