#include <macs/envelope.h>

namespace macs {

const EnvelopeData EnvelopeData::default_{};

std::string Envelope::toString() const {
    std::string result = string( "envelope " )
           + " " + mid()
           + "\n  thread: " + threadId()
           + "\n  subj: " + subject()
           + "\n  from: " + from()
           + "\n  to: " + to()
           + "\n  size: " + std::to_string(size())
           ;

    if ( labels().size() ) {
        result = result + "\n labels("
            + std::to_string( labels().size() ) + "):";
        for ( auto& l : labels() ) {
            result += l + " ";
        }
    }

    return result;
}

std::string getJournalStatusString(Envelope::Status status) {
    switch (status) {
    case Envelope::Status_read:
        return "read";
    case Envelope::Status_unread:
        return "unread";
    case Envelope::Status_replied:
        return "replied";
    case Envelope::Status_forwarded:
        return "forwarded";
    }
    throw std::invalid_argument("status not supported in macs: " + std::to_string(status));
}

}
