#include <macs/queries/envelopes_query_deleted.h>
#include <macs/envelopes_repository.h>

#include <boost/range/algorithm/copy.hpp>
#include <boost/range/adaptor/map.hpp>

namespace macs {

EnvelopesQueryDeleted::EnvelopesQueryDeleted(const EnvelopesRepository& repo)
    : repo_(repo)
    , from_(0)
    , count_(0)
    , timeInterval_(std::nullopt)
{}

EnvelopesQueryDeleted& EnvelopesQueryDeleted::from(const size_t row) {
    from_ = row;
    return *this;
}

EnvelopesQueryDeleted& EnvelopesQueryDeleted::count(const size_t count) {
    count_ = count;
    return *this;
}

EnvelopesQueryDeleted& EnvelopesQueryDeleted::withinInterval(
        const std::pair<std::time_t, std::time_t>& interval) {
    timeInterval_ = std::make_optional(interval);
    return *this;
}

void EnvelopesQueryDeleted::getInternal(OnEnvelopeReceive hook) const {
    if (timeInterval_) {
        repo_.getDeletedMessagesInInterval(from_, count_, *timeInterval_, std::move(hook));
    } else {
        repo_.getDeletedMessages(from_, count_, std::move(hook));
    }
}

}
