#include <map>

#include <boost/bind.hpp>
#include <boost/system/system_error.hpp>

#include <macs/envelope.h>
#include <macs/envelopes_repository.h>
#include <macs/queries/envelopes_query_in_mailbox.h>

using namespace std;

namespace macs {

EnvelopesQueryFilterSearch::EnvelopesQueryFilterSearch(EnvelopesRepository & repo)
        : repository_(repo) {
}

EnvelopesQueryFilterSearch& EnvelopesQueryFilterSearch::onlyUnread(bool unread) {
    unread_ = unread;
    return *this;
}

EnvelopesQueryFilterSearch& EnvelopesQueryFilterSearch::onlyAtta(bool atta) {
    atta_ = atta;
    return *this;
}

EnvelopesQueryFilterSearch& EnvelopesQueryFilterSearch::fids(const std::list<std::string>& fids) {
    fids_ = fids;
    return *this;
}

EnvelopesQueryFilterSearch& EnvelopesQueryFilterSearch::lids(const std::list<std::string>& lids) {
    lids_ = lids;
    return *this;
}

EnvelopesQueryFilterSearch& EnvelopesQueryFilterSearch::mids(const std::list<std::string>& mids) {
    mids_ = mids;
    return *this;
}

EnvelopesQueryFilterSearch& EnvelopesQueryFilterSearch::folderSet(const std::string& folderSet) {
    folderSet_ = folderSet;
    return *this;
}

EnvelopesQueryFilterSearch& EnvelopesQueryFilterSearch::sortBy(const EnvelopesSorting& order) {
    order_ = order;
    return *this;
}

void EnvelopesQueryFilterSearch::byEntry(OnEnvelopeReceive handler ) const {
    repository_.listFilterSearch( unread_, atta_, fids_, lids_, mids_, folderSet_, order_, handler );
}


}

