#include <macs/queries/envelopes_query_in_folder.h>
#include <macs/envelopes_repository.h>

#include <boost/range/algorithm/copy.hpp>
#include <boost/range/algorithm_ext/push_back.hpp>
#include <boost/range/adaptor/map.hpp>

namespace macs {

EnvelopesQueryInFolder::EnvelopesQueryInFolder(EnvelopesRepository & repo,
        FidList fids): repository_(repo), params_(fids)
{}

EnvelopesQueryInFolder::EnvelopesQueryInFolder(EnvelopesRepository & repo,
    const Folder & folder) : EnvelopesQueryInFolder( repo, FidList{ folder.fid() } )
{}

EnvelopesQueryInFolder& EnvelopesQueryInFolder::from(const size_t row) {
    params_.from = row;
    return *this;
}

EnvelopesQueryInFolder& EnvelopesQueryInFolder::from(const string & mid) {
    params_.fromMid = mid;
    return *this;
}

EnvelopesQueryInFolder& EnvelopesQueryInFolder::count(const size_t count) {
    params_.count = count;
    return *this;
}

EnvelopesQueryInFolder& EnvelopesQueryInFolder::sortBy(const EnvelopesSorting & order) {
    params_.order = order;
    return *this;
}

EnvelopesQueryInFolder& EnvelopesQueryInFolder::groupByThreads() {
    params_.groups = true;
    return *this;
}

EnvelopesQueryInFolder& EnvelopesQueryInFolder::withLabel(const Label & label) {
    params_.labels.push_back(label.lid());
    return *this;
}

EnvelopesQueryInFolder& EnvelopesQueryInFolder::withLabels(const std::vector<Label>& labelsVec) {
    using namespace boost::adaptors;
    boost::push_back(params_.labels, labelsVec | transformed([](auto& l){ return l.lid(); }));
    return *this;
}

EnvelopesQueryInFolder& EnvelopesQueryInFolder::withoutLabel(const Label & label) {
    params_.excludeLabels.push_back(label.lid());
    return *this;
}

EnvelopesQueryInFolder& EnvelopesQueryInFolder::withoutLabels(const std::vector<Label>& labelsVec) {
    using namespace boost::adaptors;
    boost::push_back(params_.excludeLabels, labelsVec | transformed([](auto& l){ return l.lid(); }));
    return *this;
}

EnvelopesQueryInFolder& EnvelopesQueryInFolder::withinInterval(const std::pair<std::time_t, std::time_t>& interval) {
    params_.timeInterval = interval;
    return *this;
}

void EnvelopesQueryInFolder::byEntry(OnEnvelopeReceive handler) const {
    repository_.envelopesQueryInFolder(params_, handler);
}

EnvelopesQueryInFolder::Params::Params(macs::FidList fids) : from(0), count(0), groups(false),
        folders( std::move(fids) ), timeInterval(std::make_pair(0, 0))
{}

}
