
#include <map>

#include <boost/bind.hpp>
#include <boost/system/system_error.hpp>

#include <macs/envelope.h>
#include <macs/envelopes_repository.h>
#include <macs/queries/envelopes_query_in_mailbox.h>

using namespace std;

namespace macs
{

EnvelopesQueryInMailbox::EnvelopesQueryInMailbox(EnvelopesRepository & repo)
: from_(0), count_(std::numeric_limits<uint32_t>::max()), groups_(false), repository_(repo) {
}

EnvelopesQueryInMailbox& EnvelopesQueryInMailbox::from(const size_t row) {
    from_ = row;
    return *this;
}

EnvelopesQueryInMailbox& EnvelopesQueryInMailbox::fromMid(const std::string & mid ){
    fromMid_ = mid;
    return *this;
}

EnvelopesQueryInMailbox& EnvelopesQueryInMailbox::count(const size_t count) {
    count_ = count;
    return *this;
}

EnvelopesQueryInMailbox& EnvelopesQueryInMailbox::sortBy(const EnvelopesSorting & order) {
    order_ = order;
    return *this;
}

EnvelopesQueryInMailbox& EnvelopesQueryInMailbox::groupByThreads() {
    groups_ = true;
    return *this;
}

EnvelopesQueryInMailbox& EnvelopesQueryInMailbox::withLabel(const Label & label) {
    labels.push_back(label.lid());
    return *this;
}

EnvelopesQueryInMailbox& EnvelopesQueryInMailbox::withoutLabel(const Label & label) {
    excludeLabels.push_back(label.lid());
    return *this;
}

void EnvelopesQueryInMailbox::byEntry(OnEnvelopeReceive handler) const {
    repository_.envelopesQueryInMailbox(fromMid_, from_, count_, groups_,
                                        order_, labels, excludeLabels, handler);
}

}

