#include <macs/envelopes_repository.h>
#include <macs/queries/envelopes_query_in_reply_to.h>

using namespace std;

namespace macs {

EnvelopesQueryInReplyTo::EnvelopesQueryInReplyTo(EnvelopesRepository &repo)
        : repository_(repo) { }


EnvelopesQueryInReplyTo& EnvelopesQueryInReplyTo::msgId(const std::string &msgId) {
    msgId_ = msgId;
    return *this;
}

EnvelopesQueryInReplyTo& EnvelopesQueryInReplyTo::mid(const std::string &mid) {
    mid_ = mid;
    return *this;
}

void EnvelopesQueryInReplyTo::byEntry(OnEnvelopeReceive handler) const {
    if (!mid_.empty()) {
        repository_.listInReplyToByMid(mid_, handler);
    } else {
        repository_.listInReplyTo(msgId_, handler);
    }
}

}

