#include <macs/queries/envelopes_query_in_tab.h>
#include <macs/envelopes_repository.h>

#include <boost/range/algorithm/copy.hpp>
#include <boost/range/algorithm_ext/push_back.hpp>
#include <boost/range/adaptor/map.hpp>

namespace macs {

EnvelopesQueryInTab::EnvelopesQueryInTab(EnvelopesRepository & repo,
        Tab::Type tabType): repository_(repo), params_(std::move(tabType))
{}

EnvelopesQueryInTab& EnvelopesQueryInTab::from(const size_t row) {
    params_.from = row;
    return *this;
}

EnvelopesQueryInTab& EnvelopesQueryInTab::count(const size_t count) {
    params_.count = count;
    return *this;
}

EnvelopesQueryInTab& EnvelopesQueryInTab::groupByThreads() {
    params_.groupByThreads = true;
    return *this;
}

EnvelopesQueryInTab& EnvelopesQueryInTab::withLabel(const Label & label) {
    params_.labels.push_back(label.lid());
    return *this;
}

EnvelopesQueryInTab& EnvelopesQueryInTab::withLabels(const std::vector<Label>& labelsVec) {
    using namespace boost::adaptors;
    boost::push_back(params_.labels, labelsVec | transformed([](auto& l){ return l.lid(); }));
    return *this;
}

EnvelopesQueryInTab& EnvelopesQueryInTab::withoutLabel(const Label & label) {
    params_.excludeLabels.push_back(label.lid());
    return *this;
}

EnvelopesQueryInTab& EnvelopesQueryInTab::withoutLabels(const std::vector<Label>& labelsVec) {
    using namespace boost::adaptors;
    boost::push_back(params_.excludeLabels, labelsVec | transformed([](auto& l){ return l.lid(); }));
    return *this;
}

EnvelopesQueryInTab& EnvelopesQueryInTab::withinInterval(const std::pair<std::time_t, std::time_t>& interval) {
    params_.timeInterval = interval;
    return *this;
}

void EnvelopesQueryInTab::byEntry(OnEnvelopeReceive handler) const {
    repository_.envelopesQueryInTab(params_, handler);
}

EnvelopesQueryInTab::Params::Params(Tab::Type tabType)
        : tabType(std::move(tabType))
        , from(0)
        , count(0)
        , groupByThreads(false)
        , timeInterval(std::make_pair(0, 0))
{}

}
