

#include <boost/bind.hpp>
#include <boost/system/system_error.hpp>

#include <map>

#include <macs/envelope.h>
#include <macs/queries/envelopes_query_in_thread.h>
#include <macs/envelopes_repository.h>

using namespace std;

namespace macs
{

EnvelopesQueryInThread::EnvelopesQueryInThread(EnvelopesRepository & repo,
    const string & threadID): tid_(threadID), repository_(repo) {}

EnvelopesQueryInThread& EnvelopesQueryInThread::from(const size_t row) {
    from_ = row;
    return *this;
}

EnvelopesQueryInThread& EnvelopesQueryInThread::from(const string & mid) {
    fromMid_ = mid;
    return *this;
}

EnvelopesQueryInThread& EnvelopesQueryInThread::count(const size_t count) {
    count_ = count;
    return *this;
}

EnvelopesQueryInThread& EnvelopesQueryInThread::sortBy(const EnvelopesSorting & order) {
    order_ = order;
    return *this;
}

EnvelopesQueryInThread& EnvelopesQueryInThread::withLabel(const Label & label) {
    if (!excludeLabel_.lid().empty()) {
        throw std::logic_error("simultaneous including and excluding labels is not implemented "
            "in EnvelopesQueryInThread");
    }
    label_ = label;
    return *this;
}

EnvelopesQueryInThread& EnvelopesQueryInThread::withoutLabel(const Label & label) {
    if (!label_.lid().empty()) {
        throw std::logic_error("simultaneous including and excluding labels is not implemented "
            "in EnvelopesQueryInThread");
    }
    excludeLabel_ = label;
    return *this;
}

void EnvelopesQueryInThread::byEntry(OnEnvelopeReceive handler) const {
    if (!label_.lid().empty()) {
        repository_.listInThreadWithLabel(tid_, label_, from_, count_, handler);
    } else if (!excludeLabel_.lid().empty()) {
        repository_.listInThreadWithoutLabel(tid_, excludeLabel_, from_, count_, handler);
    } else if (fromMid_.empty()) {
        repository_.listInThread(order_, tid_, from_, count_, handler);
    } else {
        repository_.listInThread(order_, tid_, fromMid_, count_, handler);
    }
}

}
