#include <macs/queries/envelopes_query_mids_by_conditions.h>
#include <macs/envelopes_repository.h>

namespace macs {

void EnvelopesQueryMidsByConditions::getInternal(OnMidsReceive hook) const {
    if(subject_ || from_ || age_) {
        if( excludeStatus_ ) {
            repo_.getMidsByConditionsWithoutStatus(*this, *excludeStatus_, std::move(hook));
        } else {
            repo_.getMidsByConditions(*this, std::move(hook));
        }
    } else {
        if( excludeStatus_ ) {
            if (limit_) {
                repo_.getMidsRangeByFolderWithoutStatus(fid(), *excludeStatus_, fromMid_, *limit_, std::move(hook));
            } else {
                repo_.getMidsByFolderWithoutStatus(fid(), *excludeStatus_, std::move(hook));
            }
        } else {
            if (limit_) {
                repo_.getMidsRangeByFolder(fid(), fromMid_, *limit_, std::move(hook));
            } else {
                repo_.getMidsByFolder(fid(), std::move(hook));
            }
        }
    }
}

} // namespace macs
