#include <macs/queries/envelopes_query_mids_by_tids_and_lids.h>
#include <macs/envelopes_repository.h>

namespace macs {

EnvelopesQueryMidsByTidsAndLids::EnvelopesQueryMidsByTidsAndLids(const EnvelopesRepository& repositoryToSet)
    : repository(repositoryToSet) {
}

EnvelopesQueryMidsByTidsAndLids& EnvelopesQueryMidsByTidsAndLids::withLids(Lids lidsToSet) {
    lids = std::move(lidsToSet);
    return *this;
}

EnvelopesQueryMidsByTidsAndLids& EnvelopesQueryMidsByTidsAndLids::withTids(Tids tidsToSet) {
    tids = std::move(tidsToSet);
    return *this;
}

void EnvelopesQueryMidsByTidsAndLids::getInternal(OnMidsReceive handler) const {
    repository.getMidsByTidsAndLids(tids, lids, std::move(handler));
}

}
