#include <macs/queries/envelopes_query_with_mimes.h>
#include <macs/envelopes_repository.h>

#include <boost/range/algorithm/copy.hpp>
#include <boost/range/adaptor/map.hpp>

namespace macs {

void EnvelopesQueryWithMimesInFolder::byEntry(OnEnvelopeWithMimeReceive handler) const {
    repository_.envelopesInFolderWithMimes(from_, count_, order_, fid_, handler);
}

void EnvelopesQueryWithMimesByMids::byEntry(OnEnvelopeWithMimeReceive handler) const {
    repository_.envelopesByMidsWithMimes(mids_, handler);
}

void EnvelopesQueryWithMimesInFolderByImapId::byEntry(OnEnvelopeWithMimeChunkReceive handler) const {
    if (minImapId_ < maxImapId_) {
        repository_.envelopesInFolderWithMimesByChunks(
                    static_cast<std::size_t>(minImapId_),
                    static_cast<std::size_t>(maxImapId_),
                    count_, fid_, std::move(handler));
    } else {
        handler();
    }
}

}
