#include <map>

#include <boost/system/system_error.hpp>

#include <macs/envelope.h>
#include <macs/envelopes_repository.h>
#include <macs/queries/envelopes_query_with_no_answer.h>

using namespace std;

namespace macs {

EnvelopesQueryWithNoAnswer::EnvelopesQueryWithNoAnswer(EnvelopesRepository & repo)
: repository_(repo) { }


EnvelopesQueryWithNoAnswer& EnvelopesQueryWithNoAnswer::msgId(const std::string& msgId) {
    msgId_ = msgId;
    return *this;
}

EnvelopesQueryWithNoAnswer& EnvelopesQueryWithNoAnswer::includeLabel(const std::string& includeLid) {
    includeLid_ = includeLid;
    return *this;
}


void EnvelopesQueryWithNoAnswer::byEntry(OnEnvelopeReceive handler) const {
    repository_.listWithNoAnswer(msgId_, includeLid_, handler);
}

}

