
#include <sstream>
#include <boost/unordered_map.hpp>
#include <boost/assign/list_of.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/algorithm/string.hpp>
#include <boost/algorithm/string/split.hpp>
#include <macs/label.h>

namespace macs {

const Label::Symbol Label::Symbol::attached_label(SYM_ATTACHED_LBL, "attached_label");
const Label::Symbol Label::Symbol::spam_label(SYM_SPAM_LBL, "spam_label");
const Label::Symbol Label::Symbol::answered_label(SYM_ANSWERED_LBL, "answered_label");
const Label::Symbol Label::Symbol::recent_label(SYM_RECENT_LBL, "recent_label");
const Label::Symbol Label::Symbol::draft_label(SYM_DRAFT_LBL, "draft_label");
const Label::Symbol Label::Symbol::deleted_label(SYM_DELETED_LBL, "deleted_label");
const Label::Symbol Label::Symbol::forwarded_label(SYM_FORWARDED_LBL, "forwarded_label");
const Label::Symbol Label::Symbol::important_label(SYM_IMPORTANT_LBL, "important_label");
const Label::Symbol Label::Symbol::forMe_label(SYM_FOR_ME_LBL, "forMe_label");
const Label::Symbol Label::Symbol::noBody_label(SYM_NO_BODY_LBL, "noBody_label");
const Label::Symbol Label::Symbol::noAnswer_label(SYM_NO_ANSWER_LBL, "noAnswer_label");
const Label::Symbol Label::Symbol::hasUserLabels_label(SYM_HAS_USER_LABELS_LBL, "hasUserLabels_label");
const Label::Symbol Label::Symbol::seen_label(SYM_SEEN_LBL, "seen_label");
const Label::Symbol Label::Symbol::pinned_label(SYM_PINNED_LBL, "pinned_label");
const Label::Symbol Label::Symbol::postmaster_label(SYM_POSTMASTER_LBL, "postmaster_label");
const Label::Symbol Label::Symbol::mulcaShared_label(SYM_MULCA_SHARED_LBL, "mulcaShared_label");
const Label::Symbol Label::Symbol::imap_label(SYM_IMAP_LBL, "imap_label");
const Label::Symbol Label::Symbol::append_label(SYM_APPEND_LBL, "append_label");
const Label::Symbol Label::Symbol::copy_label(SYM_COPY_LBL, "copy_label");
const Label::Symbol Label::Symbol::synced_label(SYM_SYNCED_LBL, "synced_label");
const Label::Symbol Label::Symbol::remindNoAnswer_label(SYM_REMIND_NO_ANSWER_LBL, "remindNoAnswer_label");
const Label::Symbol Label::Symbol::notifyNoAnswer_label(SYM_NOTIFY_NO_ANSWER_LBL, "notifyNoAnswer_label");
const Label::Symbol Label::Symbol::remindMessage_label(SYM_REMIND_MESSAGE_LBL, "remindMessage_label");
const Label::Symbol Label::Symbol::notifyMessage_label(SYM_NOTIFY_MESSAGE_LBL, "notifyMessage_label");
const Label::Symbol Label::Symbol::mute_label(SYM_MUTE_LBL, "mute_label");
const Label::Symbol Label::Symbol::delayedMessage_label(SYM_DELAYED_MESSAGE_LBL, "delayed_message");
const Label::Symbol Label::Symbol::undoMessage_label(SYM_UNDO_MESSAGE_LBL, "undo_message");
const Label::Symbol Label::Symbol::hamon_label(SYM_HAMON_LBL, "hamon_label");
const Label::Symbol Label::Symbol::encrypted_label(SYM_ENCRYPTED_LBL, "encrypted_label");
const Label::Symbol Label::Symbol::mention_label(SYM_MENTION_LBL, "mention_label");
const Label::Symbol Label::Symbol::mention_unvisited_label(SYM_MENTION_UNVISITED_LBL, "mention_unvisited_label");
const Label::Symbol Label::Symbol::sending_failed_label(SYM_SENDING_FAILED_LBL, "sending_failed_label");
const Label::Symbol Label::Symbol::from_favorite_user_label(SYM_FROM_FAVORITE_USER_LBL, "from_favorite_user_label");
const Label::Symbol Label::Symbol::reply_later_started(SYM_REPLY_LATER_STARTED, "reply_later_started");
const Label::Symbol Label::Symbol::reply_later_finished(SYM_REPLY_LATER_FINISHED, "reply_later_finished");


const Label::Symbol Label::Symbol::none(SYM_LABEL_NONE, "");

//Hardcoded numbers from PL/SQL package "StoreLabels"
const Label::Type Label::Type::user(1,"user");
const Label::Type Label::Type::social(2,"social");
const Label::Type Label::Type::system(3,"system");
const Label::Type Label::Type::status(4,"status");
const Label::Type Label::Type::imap(5,"imap");
const Label::Type Label::Type::threadWide(6,"threadWide");
const Label::Type Label::Type::rpop(7,"rpop");
const Label::Type Label::Type::phone(8,"phone");
const Label::Type Label::Type::spamDefense(9,"so");
const Label::Type Label::Type::spamDefense2(10,"so2");

} // namespace macs

