#include <butil/StrUtils/StrUtils.h>
#include <macs/mail_reference.h>

namespace macs {

const std::string::size_type FNV_PROCESSING_MAX_SIZE = 3071;
const uint64_t FNV_OFFSET_BASIS = 14695981039346656037u;
const uint64_t FNV_PRIME = 1099511628211;

inline uint64_t getFNVHash (const std::string& src) {
    uint64_t hashVal = FNV_OFFSET_BASIS;
    for (size_t i = 0; i < src.size(); i++) {
        hashVal *= FNV_PRIME;
        hashVal ^= static_cast<uint64_t>(src[i]);
    }
    return hashVal;
}

uint64_t getMailReference (const std::string& msgId) {
    const auto normalizedSrc = TStrUtils::stringToLower(
            TStrUtils::trim(msgId, " ")).substr(0, FNV_PROCESSING_MAX_SIZE);
    return getFNVHash(normalizedSrc);
}

} // namespace macs

