#include <boost/range/algorithm.hpp>

#include <macs/settings_utils.h>

namespace macs::settings::utils {

void filterSettings(SettingsMap& settings, const SettingsList& list) {
    if(list.empty()) {
        return;
    }
    for (auto it = settings.begin(); it != settings.end();) {
        if (boost::range::find(list, it->first) == list.end()) {
            it = settings.erase(it);
        } else {
            ++it;
        }
    }
}

void addSignatures(Profile& profile, SignaturesListOpt& signs, const SettingsList& settings) {
    if (settings.empty() || boost::range::find(settings, "signs") != settings.end()) {
        profile.signs = std::move(signs);
    }
};

}
