#include <macs/tabs_repository.h>
#include <macs/method_caller.h>
#include <future>

namespace macs {

TabsRepository::CachePtr TabsRepository::tabsInternal() const {
    std::promise<CachePtr> p;
    auto f = p.get_future();
    tabsInternal([&](error_code e, CachePtr v){
        auto res = std::move(p);
        if(e) {
            mail_errors::setSystemError(res, "tabsInternal", e);
        } else {
            res.set_value(v);
        }
    });
    return f.get();
}

void TabsRepository::getOrCreateTabInternal(const Tab::Type& type, OnUpdateTab hook) const {
    asyncGetOrCreateTab(type, [self = shared_from_this(), hook = std::move(hook)]
            (error_code ec, Tab tab) {
        if (ec) {
            hook(std::move(ec));
            return;
        }
        self->resetTabsCache();
        hook(std::move(ec), tab);
    });
}

void TabsRepository::resetFreshInternal(const Tab& tab, OnUpdate hook) const {
    if (tab.freshMessagesCount() > 0) {
        asyncResetFresh(tab.type(), [self = shared_from_this(), hook = std::move(hook)]
                (error_code ec, Revision revision) {
            if (!ec) {
                self->resetTabsCache();
            }
            hook(std::move(ec), revision);
        });
    } else {
        hook(error_code(), NULL_REVISION);
    }
}

} // namespace macs
