#include <butil/email/helpers.h>
#include <macs/thread_participants_factory.h>

namespace macs {

class IsParticipantEmailEqual {
private:
    const Email& email_;
public:
    IsParticipantEmailEqual(const Email& email) : email_(email) {}

    bool operator() (const ThreadParticipants::Participant &participant) const {
        return EmailHelpers::isEqualEmails(participant.from(), email_);
    }
};

bool ThreadParticipantsFactory::existParticipant (const Email &email) const {
    return std::find_if(threadParticipants.participants_.begin(), threadParticipants.participants_.end(),
            IsParticipantEmailEqual(email)) != threadParticipants.participants_.end();
}

} // ns macs
