#pragma once

#include <internal/query/ids.h>

#include <pgg/query/boundaries.h>

namespace macs::pg::query {

struct BackupStatus : pgg::query::QueryImpl<BackupStatus, UserId> {
    using Inherited::Inherited;
};

struct BackupSettings : pgg::query::QueryImpl<BackupSettings, UserId> {
    using Inherited::Inherited;
};

struct BackupChangeSettings : pgg::query::QueryImpl<BackupChangeSettings, UserId, pgg::RequestInfo, FolderIdVector, TabTypes> {
    using Inherited::Inherited;
};

struct BackupCreate : pgg::query::QueryImpl<BackupCreate, UserId, pgg::RequestInfo, BackupId, MaxMessagesInBackup, UseTabs> {
    using Inherited::Inherited;
};

struct BackupFill : pgg::query::QueryImpl<BackupFill, UserId, pgg::RequestInfo, BackupId, UseTabs> {
    using Inherited::Inherited;
};

struct BackupRestore : pgg::query::QueryImpl<BackupRestore, UserId, pgg::RequestInfo, BackupId, CreationTs, RestoreMethod, BackupFidToFidVec> {
    using Inherited::Inherited;
};

struct BackupNextId : pgg::query::QueryImpl<BackupNextId, UserId, pgg::RequestInfo> {
    using Inherited::Inherited;
};

struct BackupFolders : pgg::query::QueryImpl<BackupFolders, UserId, BackupId> {
    using Inherited::Inherited;
};

struct BackupMessagesToRestore : pgg::query::QueryImpl<BackupMessagesToRestore, UserId, BackupId, RowCount> {
    using Inherited::Inherited;
};

struct BackupMessagesInFolderToRestore : pgg::query::QueryImpl<BackupMessagesInFolderToRestore, UserId, BackupId, RowCount, FolderId> {
    using Inherited::Inherited;
};

struct BackupDeleteMessages : pgg::query::QueryImpl<BackupDeleteMessages, UserId, BackupId, MailIds> {
    using Inherited::Inherited;
};

struct BackupUpdateMids : pgg::query::QueryImpl<BackupUpdateMids, UserId, pgg::RequestInfo, BackupId, BackupMidToMidVec> {
    using Inherited::Inherited;
};

struct BackupDeactivate : pgg::query::QueryImpl<BackupDeactivate, UserId, pgg::RequestInfo> {
    using Inherited::Inherited;
};

struct BackupFail : pgg::query::QueryImpl<BackupFail, UserId, pgg::RequestInfo, FailReason> {
    using Inherited::Inherited;
};

struct BackupRestoreFail : pgg::query::QueryImpl<BackupRestoreFail, UserId, pgg::RequestInfo, FailReason> {
    using Inherited::Inherited;
};

struct BackupRestoreComplete : pgg::query::QueryImpl<BackupRestoreComplete, UserId, pgg::RequestInfo> {
    using Inherited::Inherited;
};

}
