#pragma once

#include <macs_pg/logging.h>

#include <macs/backups_repository.h>
#include <pgg/query/repository.h>
#include <pgg/request_info.h>
#include <internal/query/comment.h>

namespace macs::pg {

template <typename DatabaseGenerator>
class BackupsRepository: public macs::BackupsRepository {
public:
    BackupsRepository(const DatabaseGenerator& db, const std::string& uid,
                      pgg::query::RepositoryPtr queryRepository,
                      logging::v2::LogPtr logger, const pgg::RequestInfo& requestInfo)
        : db(db)
        , uid_(uid)
        , queryRepository_(queryRepository)
        , logger_(logger)
        , requestInfo_(requestInfo)
    { }

    void asyncStatus(OnBackupStatus) const override;
    void asyncCreateBackup(macs::BackupId, int32_t, bool, OnExecute) const override;
    void asyncFillBackup(macs::BackupId, bool, OnExecute) const override;
    void asyncRestore(macs::BackupId, std::time_t, macs::RestoreMethod, macs::BackupFidsMapping, OnExecute) const override;
    void asyncId(OnBackupId) const override;
    void asyncSettings(OnBackupSettings) const override;
    void asyncChangeSettings(const BackupSettings&, OnBackupSettings) const override;
    void asyncFolders(macs::BackupId, OnBackupFolders) const override;
    void asyncSelectMessages(macs::BackupId, uint64_t, OnBackupBox) const override;
    void asyncSelectMessagesInFolder(macs::BackupId, uint64_t, macs::Fid fid, OnBackupBox) const override;
    void asyncDeleteMessages(macs::BackupId, macs::MidVec, OnExecute) const override;
    void asyncUpdateMessages(macs::BackupId, macs::BackupMidToMid, OnExecute) const override;
    void asyncCompleteRunningRestore(OnExecute) const override;
    void asyncFailRunningRestore(std::string, OnExecute) const override;
    void asyncFailRunningBackup(std::string, OnExecute) const override;
    void asyncDeactivateBackup(OnExecute) const override;

private:
    template <typename T, typename ...ArgsT >
    T query(ArgsT&& ... args) const {
        return makeQueryWithComment<T>(*queryRepository_, uid_, std::forward<ArgsT>(args) ...);
    }

    template <typename T, typename ...ArgsT >
    T queryUpdate(ArgsT&& ... args) const {
        return makeQueryWithComment<T>(*queryRepository_, uid_, requestInfo_, std::forward<ArgsT>(args) ...);
    }

    const DatabaseGenerator db;
    const std::string uid_;
    const pgg::query::RepositoryPtr queryRepository_;
    logging::v2::LogPtr logger_;
    const pgg::RequestInfo requestInfo_;
};

template <typename DatabaseGenerator>
BackupsRepositoryPtr createBackupsRepository(
    const DatabaseGenerator& db,
    const std::string& uid,
    pgg::query::RepositoryPtr queryRepository,
    logging::v2::LogPtr logger,
    const pgg::RequestInfo& requestInfo);

}

#include "repository.ipp"
