#pragma once

#include <macs_pg/subscription/repository.h>
#include <macs_pg/change_queue/repository.h>

#include <pgg/database/database.h>
#include <pgg/query/repository.h>

namespace macs {
namespace pg {

template <typename DatabaseGenerator>
class ChangeQueueRepository : public macs::ChangeQueueRepository {
public:
    typedef macs::ChangeQueueRepository Base;

    ChangeQueueRepository(const DatabaseGenerator& generator,
                           pgg::query::RepositoryPtr queryRepository,
                           pgg::Milliseconds /*transactionTimeout*/)
    : Base(), queryRepository_(queryRepository), db(std::move(generator))
    {}

    virtual ~ChangeQueueRepository() = default;

private:
    // macs methods
    virtual void asyncGet(std::string uid,
                          SubscriptionId subscriptionId,
                          size_t count,
                          OnChangeIdChunkReceive hook) const override;

    void asyncGet(WorkerId id, OnChangeReferenceChunk hook) const override;

    virtual void asyncRemove(std::vector<::macs::ChangeReference> changes,
                             OnExecute hook) const override;

    const pgg::query::Repository& queryRepository() const {
        return *queryRepository_;
    }
    std::shared_ptr<const ChangeQueueRepository> getSelf() const {
        return std::dynamic_pointer_cast<const ChangeQueueRepository>(pgg::share(this));
    }

    pgg::query::RepositoryPtr queryRepository_;
    const DatabaseGenerator db;
};


} // namespace pg
} // namespace macs

#include "repository.ipp"
