#include <utility>
#include <sstream>

#include <internal/change_queue/repository.h>
#include <internal/change_queue/query.h>
#include <internal/hooks/wrap.h>
#include <internal/reflection/change_queue.h>

namespace macs {
namespace pg {

template <typename DatabaseGenerator>
void ChangeQueueRepository<DatabaseGenerator>::asyncGet(std::string uid,
                                     SubscriptionId subscriptionId,
                                     size_t count,
                                     OnChangeIdChunkReceive hook) const {
    const auto q = queryRepository().template query<query::GetChangesFromQueue>(
        query::UserId(uid),
        query::SubscriptionId(subscriptionId),
        query::RowCount(count));
    db()->fetch(q, wrapHook<reflection::ChangeQueue>(
            std::move(hook),
            [](auto v) {return v.cid;}));
}

template <typename DatabaseGenerator>
void ChangeQueueRepository<DatabaseGenerator>::asyncGet(WorkerId id, OnChangeReferenceChunk hook) const {
    const auto q = queryRepository().template query<query::GetChangesFromQueueByWorkerId>(id);
    db()->fetch(q, wrapHook<reflection::ChangeReference>(
        std::move(hook),
        [](auto v) { return ChangeReference{
            v.cid, std::to_string(v.uid), v.subscription_id};
    }));
}

template <typename DatabaseGenerator>
void ChangeQueueRepository<DatabaseGenerator>::asyncRemove(std::vector<ChangeReference> changes,
                                        OnExecute hook) const {
    const auto q = queryRepository().template query<query::RemoveChangesFromQueue>(
            query::ChangeReferenceVec(changes));
    db()->execute(q, std::move(hook));
}


} // namespace pg
} // namespace macs
