#pragma once

#include <pgg/query/boundaries.h>
#include <internal/query/ids.h>

namespace macs {
namespace pg {
namespace query {

using pgg::query::QueryImpl;

struct ChangesById : QueryImpl<ChangesById, ChangeIdVec> {
    using Inherited::Inherited;
};

struct MinimumKnownChangeId : QueryImpl<MinimumKnownChangeId> {
    using Inherited::Inherited;
};

struct ChangesByUid : QueryImpl<ChangesByUid, UserId, Revision, Limit> {
    using Inherited::Inherited;
};

struct GetChangeIdByRevision : QueryImpl<GetChangeIdByRevision, UserId, Revision> {
    using Inherited::Inherited;
};

struct ChangelogByUid : QueryImpl<ChangelogByUid, UserId, Revision, Limit> {
    using Inherited::Inherited;
};

struct ChangelogByUidAndType : QueryImpl<ChangelogByUidAndType, UserId, Revision, Limit, ChangeLogTypes> {
    using Inherited::Inherited;
};

} // namespace query
} // namespace pg
} // namespace macs
