#pragma once

#include <macs_pg/collectors/collector.h>
#include <macs_pg/collectors/collector_factory.h>
#include <internal/collectors/state.h>
#include <internal/reflection/collector.h>
#include <pgg/numeric_cast.h>

namespace macs::pg {

inline Collector toCollector(const reflection::Collector& v) {
    CollectorFactory factory;
    factory
        .uid(std::to_string(v.uid))
        .collectorId(CollectorId(v.collector_id))
        .srcUid(v.src_uid)
        .authToken(v.auth_token)
        .rootFolderId(v.root_folder_id)
        .labelId(v.label_id)
        .ignoreFoldersStruct(v.ignore_folders_struct)
        .creationTs(PGG_NUMERIC_CAST(std::time_t, v.creation_ts))
        .lastMid(v.last_mid)
        .skippedMids(v.skipped_mids)
        .state(CollectorState::fromString(v.state))
        .oldPopid(OldPopid(PGG_NUMERIC_CAST(std::uint64_t, v.old_popid)))
        .migratedLastMid(v.migrated_last_mid)
        .originalServer(v.original_server)
        .migrationTargetState(CollectorState::fromString(v.migration_target_state));
    return factory.release();
}

}
