#pragma once

#include <internal/reflection/collector_id_result.h>
#include <macs_pg/collectors/collector_id.h>
#include <macs/revision.h>
#include <pgg/numeric_cast.h>

namespace macs::pg {

inline CollectorIdResult toCollectorIdResult(const reflection::CollectorIdResult& v) {
    return {PGG_NUMERIC_CAST(Revision, v.revision), CollectorId(v.collector_id)};
}

}
