#pragma once

#include <internal/query/ids.h>

#include <pgg/query/boundaries.h>

namespace macs::pg::query {

using pgg::query::QueryImpl;

struct CreateCollector: public QueryImpl<CreateCollector, UserId, SrcUserId, CollectorsAuthToken, OptionalFolderId, OptionalLabelId> {
    using Inherited::Inherited;
};

struct AddMigrationData: public QueryImpl<AddMigrationData, UserId, CollectorId, CollectorsIgnoreFoldersStruct, CollectorsLastMid, CollectorsSkippedMids, OldPopid, CreationTs, CollectorsOriginalServer, CollectorsState> {
    using Inherited::Inherited;
};

struct ResetCollector: public QueryImpl<ResetCollector, UserId, CollectorId, CollectorsState, CollectorsAuthToken, FolderId, LabelId, CollectorsLastMid, CollectorsSkippedMids, CreationTs> {
    using Inherited::Inherited;
};

struct DeleteCollector: public QueryImpl<DeleteCollector, UserId, CollectorId> {
    using Inherited::Inherited;
};

struct UpdateCollectorsSkippedMids: public QueryImpl<UpdateCollectorsSkippedMids, UserId, CollectorId, CollectorsSkippedMids> {
    using Inherited::Inherited;
};

struct UpdateCollectorsLastMid: public QueryImpl<UpdateCollectorsLastMid, UserId, CollectorId, CollectorsLastMid> {
    using Inherited::Inherited;
};

struct UpdateCollectorsState: public QueryImpl<UpdateCollectorsState, UserId, CollectorId, CollectorsState> {
    using Inherited::Inherited;
};

struct UpdateCollectorsMigrationTargetState: public QueryImpl<UpdateCollectorsMigrationTargetState, UserId, CollectorId, CollectorsState> {
    using Inherited::Inherited;
};

struct EditCollector: public QueryImpl<EditCollector, UserId, CollectorId, CollectorsAuthToken, FolderId, LabelId> {
    using Inherited::Inherited;
};

struct ResetCollectorsToken: public QueryImpl<ResetCollectorsToken, UserId, CollectorId> {
    using Inherited::Inherited;
};

struct GetCollectorsUsers: public QueryImpl<GetCollectorsUsers> {
    using Inherited::Inherited;
};

struct GetCollectorsUsersChanges: public QueryImpl<GetCollectorsUsersChanges, LastMovedDate, LastDeletedDate> {
    using Inherited::Inherited;
};

struct GetCollectors: public QueryImpl<GetCollectors, UserIds> {
    using Inherited::Inherited;
};

struct MailboxEntriesAfterMid: public QueryImpl<MailboxEntriesAfterMid, UserId, MailId, RowCount> {
    using Inherited::Inherited;
};

struct MailboxEntriesAfterMidInPop3Box: public QueryImpl<MailboxEntriesAfterMidInPop3Box, UserId, MailId, RowCount> {
    using Inherited::Inherited;
};

}
