#pragma once

#include <macs_pg/collectors/repository.h>

#include <internal/query/comment.h>

#include <pgg/query/repository.h>

namespace macs::pg {

template <typename DatabaseGenerator>
class CollectorsRepository: public macs::CollectorsRepository {
public:
    CollectorsRepository(const Uid& uid, const DatabaseGenerator& generator,
            pgg::query::RepositoryPtr queryRepository, pgg::Milliseconds transactionTimeout)
        : uid_(uid)
        , db(generator)
        , queryRepository_(queryRepository)
        , transactionTimeout_(transactionTimeout)
    {
    }

private:
    void asyncCreateCollector(CollectorFactory factory,
                              OnCollectorResult hook) const override;
    void asyncMigrateCollector(CollectorFactory factory,
                               OnCollectorResult hook) const override;
    void asyncResetCollector(const CollectorFactory& factory, OnUpdate hook) const override;
    void asyncDeleteCollector(CollectorId collectorId, OnUpdate hook) const override;
    void asyncUpdateSkippedMids(CollectorId collectorId,
                                const MidVec& skippedMids,
                                OnExecute hook) const override;
    void asyncUpdateLastMid(CollectorId collectorId,
                            const Mid& lastMid,
                            OnExecute hook) const override;
    void asyncUpdateState(CollectorId collectorId,
                          const macs::CollectorState& newState,
                          OnUpdate hook) const override;
    void asyncUpdateMigrationTargetState(CollectorId collectorId,
                                         const macs::CollectorState& newState,
                                         OnUpdate hook) const override;
    void asyncUpdateCollector(const CollectorFactory& factory, OnUpdate hook) const override;
    void asyncResetToken(CollectorId collectorId, OnExecute hook) const override;
    void asyncGetNextEnvelopeChunk(const Mid& id,
                                   const uint64_t count,
                                   LabelSet labels,
                                   OnEnvelopeChunkReceive hook) const override;
    void asyncGetNextPop3EnvelopeChunk(const Mid& id,
                                       const uint64_t count,
                                       LabelSet labels,
                                       OnEnvelopeChunkReceive hook) const override;

    const std::string & uid() const { return uid_; }

    template <typename T, typename ...ArgsT >
    T makeQuery(ArgsT&& ... args) const {
        return makeQueryWithComment<T>(queryRepository(), uid(),
            std::forward<ArgsT>(args) ...);
    }

    const pgg::query::Repository & queryRepository() const {
        return *queryRepository_;
    }

    const Uid uid_;
    const DatabaseGenerator db;
    pgg::query::RepositoryPtr queryRepository_;
    pgg::Milliseconds transactionTimeout_;
};

template <typename DatabaseGenerator>
CollectorsRepositoryPtr createCollectorsRepository(
    const std::string& uid,
    DatabaseGenerator dbg,
    pgg::query::RepositoryPtr repo,
    pgg::Milliseconds timeout);

}

#include "repository.ipp"
