#pragma once

#include <macs_pg/collectors/shard_repository.h>

#include <internal/query/comment.h>

#include <pgg/query/repository.h>

namespace macs::pg {

template <typename DatabaseGenerator>
class CollectorsShardRepository : public macs::CollectorsShardRepository {
public:
    CollectorsShardRepository(const DatabaseGenerator &generator, pgg::query::RepositoryPtr queryRepository)
        : db(generator)
        , queryRepository_(queryRepository)
    {
    }

private:
    void asyncGetUsers(OnShardUserList hook) const override;

    void asyncGetChanges(std::time_t lastMovedDate,
                         std::time_t lastDeletedDate,
                         OnShardUserList hook) const override;

    void asyncGetCollectors(std::vector<Uid> uidsList,
                           OnCollectorsList hook) const override;

    const pgg::query::Repository & queryRepository() const {
        return *queryRepository_;
    }

    const DatabaseGenerator db;
    pgg::query::RepositoryPtr queryRepository_;
};

}

#include "shard_repository.ipp"
