#include <internal/collectors/shard_repository.h>
#include <internal/collectors/query.h>
#include <internal/collectors/collector.h>
#include <internal/shard_user.h>
#include <internal/query/ids.h>
#include <internal/hooks/wrap.h>

namespace macs::pg {

template <typename DatabaseGenerator>
void CollectorsShardRepository<DatabaseGenerator>::asyncGetUsers(OnShardUserList hook) const {
    const auto q = queryRepository().template query<query::GetCollectorsUsers>();
    auto wrapper = wrapHook<reflection::ShardUser>(std::move(hook), toShardUser);
    db()->fetch(q, std::move(wrapper));
}

template <typename DatabaseGenerator>
void CollectorsShardRepository<DatabaseGenerator>::asyncGetChanges(std::time_t lastMovedDate,
        std::time_t lastDeletedDate, OnShardUserList hook) const {
    const auto q = queryRepository().template query<query::GetCollectorsUsersChanges>(
        query::LastMovedDate(lastMovedDate), query::LastDeletedDate(lastDeletedDate));
    auto wrapper = wrapHook<reflection::ShardUser>(std::move(hook), toShardUser);
    db()->fetch(q, std::move(wrapper));
}

template <typename DatabaseGenerator>
void CollectorsShardRepository<DatabaseGenerator>::asyncGetCollectors(std::vector<Uid> uidsList,
        OnCollectorsList hook) const {
    const auto q = queryRepository().template query<query::GetCollectors>(query::UserIds(uidsList));
    auto wrapper = wrapHook<reflection::Collector>(std::move(hook), toCollector);
    db()->fetch(q, std::move(wrapper));
}

}
