#pragma once

#include <macs_pg/collectors/collector.h>
#include <pgg/enumeration.h>
#include <boost/assign.hpp>

namespace macs::pg {

struct CollectorStateImpl {
    using Enum = macs::CollectorState;
    using Filler = CollectorStateImpl;
    using Map = pgg::Enum2String<Enum>::Map;

    void fill(Map & map) {
        boost::assign::insert(map)
            ( Enum::undefined, "" )
            ( Enum::created,   "created" )
            ( Enum::ready,     "ready" )
            ( Enum::disabled,  "disabled" )
            ( Enum::deleted,   "deleted" )
            ( Enum::migrated,  "migrated" )
            ( Enum::unmigrated,  "unmigrated" );
    }
};

using CollectorState = pgg::Enumeration<CollectorStateImpl, CollectorStateImpl::Enum::undefined>;

}
