#pragma once

#include <macs/database_info.h>
#include <macs/hooks.h>
#include <pgg/service/uid_resolver.h>

namespace macs::pg {

DatabaseState::State resolveDbState(const pgg::ShardInfo& shard);

template <typename Resolver>
class DatabaseInfo : public macs::DatabaseInfo {
    using ResolverPtr = std::shared_ptr<Resolver>;
    using ResolveParams = typename Resolver::Params;
    using Id = typename Resolver::Id;
public:
    DatabaseInfo(ResolverPtr resolver, const Id& id)
        : resolver_(std::move(resolver)), params_(id)
    {}

    void syncDatabaseInfo(OnDatabaseState hook) const override {
        resolver_->asyncGetShardStatus(params_,
                [=](error_code ec, pgg::ShardInfo shard){
            if (ec) {
                hook(std::move(ec), DatabaseState{});
            } else {
                hook(error_code(), DatabaseState{shard.name, resolveDbState(shard)});
            }
        });
    }

private:
    ResolverPtr resolver_;
    ResolveParams params_;
};

template <typename Resolver, typename Id>
inline auto createDatabaseInfo(std::shared_ptr<Resolver> resolver, Id id) {
    return std::make_shared<DatabaseInfo<Resolver>>(std::move(resolver), std::move(id));
}

} // namespace macs::pg

