#pragma once

#include <internal/envelope/recipient.h>

#include <algorithm>
#include <vector>

namespace macs {
namespace pg {

struct FromRecipientsMatcher {
    explicit FromRecipientsMatcher(const std::string& hdr_from) {
        fromStringWithType(hdr_from, Recipient::Type::from, froms);
    }

    bool match(const std::vector<Recipient::Reflection>& reflections) const {
        std::vector<Recipient> needToBeChecked;
        reflectionsToRecipients(reflections, needToBeChecked);
        if (froms.size() != needToBeChecked.size()) {
            return false;
        }
        auto nonMatched = std::mismatch(froms.begin(), froms.end(), needToBeChecked.begin(),
            [] (const Recipient & a, const Recipient & b) {
                return a.address() == b.address();
        });
        return nonMatched.first == froms.end();
    }

private:
    void reflectionsToRecipients(const std::vector<Recipient::Reflection>& reflections,
        std::vector<Recipient>& rcpts) const {
        for (const auto & r : reflections) {
            Recipient rcpt(r);
            if (rcpt.type() == Recipient::Type::from) {
                rcpts.push_back(std::move(rcpt));
            }
        }
    }

    std::vector<Recipient> froms;
};

} // namespace pg
} // namepsace macs
