#ifndef INCLUDE_INTERNAL_ENVELOPE_MESSAGE_ATTACH_H_191223042015
#define INCLUDE_INTERNAL_ENVELOPE_MESSAGE_ATTACH_H_191223042015

#include <macs/envelope.h>
#include <pgg/numeric_cast.h>
#include <internal/reflection/message_attach.h>
#include <string>
#include <boost/tuple/tuple.hpp>

namespace macs {
namespace pg {

class MessageAttach {
public:
    using Hid = std::string;
    using ContentType = std::string;
    using Filename = std::string;
    using Size = std::size_t;
    using Tuple =  boost::tuple<Hid,ContentType, Filename, Size>;
    using Reflection = reflection::MessageAttach;

    const Hid & hid() const { return get<0>();}
    const ContentType & contentType() const { return get<1>();}
    const Filename & filename() const { return get<2>();}
    const Size & size() const { return get<3>();}
    const Tuple & tuple() const { return t; }

    Hid & hid() { return get<0>();}
    ContentType & contentType() { return get<1>();}
    Filename & filename() { return get<2>();}
    Size & size() { return get<3>();}
    Tuple & tuple() { return t; }

    MessageAttach(Tuple t) : t(std::move(t)) {}
    MessageAttach() = default;
    MessageAttach(Reflection r)
        : t(std::move(r.hid), std::move(r.type), std::move(r.filename),
                PGG_NUMERIC_CAST(std::size_t, r.size)) {}

private:
    template < int N >
    using Element = typename boost::tuples::element<N, Tuple>::type;
    template < int N >
    const Element<N> & get() const { return boost::get<N>(tuple()); }
    template < int N >
    Element<N> & get() { return boost::get<N>(tuple()); }
    Tuple t;
};

inline MessageAttach fromAttachmentDescriptor( AttachmentDescriptor a ) {
    return MessageAttach(
            boost::make_tuple(
                    std::move(a.m_hid),
                    std::move(a.m_contentType),
                    std::move(a.m_fileName),
                    a.m_size));
}

inline AttachmentDescriptor toAttachmentDescriptor( MessageAttach a) {
    return AttachmentDescriptor(
                    std::move(a.hid()),
                    std::move(a.contentType()),
                    std::move(a.filename()),
                    a.size());
}

} // namespace pg
} // namespace macs

#endif /* INCLUDE_INTERNAL_ENVELOPE_MESSAGE_ATTACH_H_191223042015 */
