#ifndef MACS_PG_ENVELOPE_MESSAGE_ATTRIBUTES_H_172119092014
#define MACS_PG_ENVELOPE_MESSAGE_ATTRIBUTES_H_172119092014

#include <pgg/enumeration.h>
#include <internal/label/fake.h>
#include <boost/bimap.hpp>

namespace macs {
namespace pg {

struct __MessageAttributes{
    enum Enum {
        unknown,
        spam,
        postmaster,
        mulcaShared,
        append,
        copy,
        synced
    };
    typedef pgg::Enum2String<Enum>::Map Map;
    void fill(Map & map) const{
#define ADD_ENUM_TO_MAP(name) map.insert(Map::value_type(name, #name))
        ADD_ENUM_TO_MAP(unknown);
        ADD_ENUM_TO_MAP(spam);
        ADD_ENUM_TO_MAP(postmaster);
        map.insert(Map::value_type(mulcaShared, "mulca-shared"));
        ADD_ENUM_TO_MAP(append);
        ADD_ENUM_TO_MAP(copy);
        ADD_ENUM_TO_MAP(synced);
#undef ADD_ENUM_TO_MAP
    }
    typedef __MessageAttributes Filler;
};

typedef pgg::Enumeration<__MessageAttributes> MessageAttributes;

class MessageAttrubutesConverter {
public:
    MessageAttributes fromLabelId( const std::string & lid ) const {
        const auto & labels = fakeLabels();
        const auto i = labels.find(lid);
        return i == labels.end() ? MA(MA::unknown) : attr( i->symbolicName());
    }
    std::string toLabelId(MessageAttributes a) const {
        const auto & labels = fakeLabels();
        const auto i = labels.find(symbol(a));
        return i == labels.end() ? "" : i->lid();
    }

    const Label::Symbol & symbol(MessageAttributes attr) const {
        return get(map().left, attr, Sym::none );
    }

    MessageAttributes attr(const Label::Symbol & sym) const {
        return get(map().right, sym, MA::unknown);
    }
private:
    using MA = MessageAttributes;
    using Sym = Label::Symbol;
    using Map = boost::bimap<MA,Sym>;

    static Map makeMap() {
        using V = Map::value_type;
        Map m;
        m.insert(V( MA::spam, Sym::spam_label ));
        m.insert(V( MA::postmaster, Sym::postmaster_label ));
        m.insert(V( MA::mulcaShared, Sym::mulcaShared_label ));
        m.insert(V( MA::append, Sym::append_label ));
        m.insert(V( MA::copy, Sym::copy_label ));
        m.insert(V( MA::synced, Sym::synced_label ));
        m.insert(V( MA::unknown, Sym::none ));
        return m;
    }

    static const Map & map() {
        static const Map m = makeMap();
        return m;
    }

    template <typename T>
    using CRef = const typename T::value_type::second_type &;

    template <typename Map, typename Key>
    CRef<Map> get( const Map & map, const Key & key, CRef<Map> defVal ) const {
        const auto i = map.find(key);
        return  i==map.end() ? defVal : i->second;
    }
};

inline std::string attributeToLid( MessageAttributes v ) {
    return MessageAttrubutesConverter().toLabelId(v);
}

inline MessageAttributes lidToAttribute( const std::string & lid ) {
    return MessageAttrubutesConverter().fromLabelId(lid);
}

} // namespace pg
} // namespace macs

#endif /* MESSAGE_ATTRIBUTES_H_ */
