#ifndef INCLUDE_INTERNAL_ENVELOPE_MIME_PARTS_H_
#define INCLUDE_INTERNAL_ENVELOPE_MIME_PARTS_H_

#include <pgg/query/helper.h>
#include <internal/reflection/mime_part.h>
#include <macs/mime_part_factory.h>
#include <boost/optional.hpp>
#include <boost/range/algorithm/transform.hpp>
#include <boost/hana/tuple.hpp>

namespace pgg {
namespace query {

template<typename Base>
struct Helper<Base, macs::MimeParts> {
    using StoreMimePart =  macs::pg::reflection::MimePart;
    using StoreMime = std::vector<StoreMimePart>;

    template <typename MapperT>
    void map(const MapperT & m) const {
        m.mapValue(makeStoreMime(), "mime");
    }

    auto get() const {
        return makeStoreMime();
    }

    void set(const macs::MimeParts & mime) {
        mime_ = mime;
    }

    Base & mime( const macs::MimeParts & mime ) {
        mime_ = mime;
        return static_cast<Base&>(*this);
    }
private:
    boost::optional<StoreMime> makeStoreMime() const {
        boost::optional<StoreMime> storeMime;
        if (!mime_.empty()) {
            storeMime = StoreMime();
            boost::transform(mime_, std::back_inserter(*storeMime), [] (const macs::MimePart& mp) {
                return StoreMimePart(mp.hid(), mp.contentType(), mp.contentSubtype(), mp.boundary(),
                        mp.name(), mp.charset(), mp.encoding(), mp.contentDisposition(),
                        mp.fileName(), mp.cid(), static_cast<int64_t>(mp.offsetBegin()),
                        static_cast<int64_t>(mp.offsetEnd()));
            });
        }
        return storeMime;
    }

    macs::MimeParts mime_;
};

} // namespace query
} // namespace pgg

namespace macs {
namespace pg {

inline MimePart toMimePart(reflection::MimePart r) {
    return MimePartFactory().hid(std::move(r.hid)).contentType(std::move(r.content_type))
            .contentSubtype(std::move(r.content_subtype)).boundary(std::move(r.boundary))
            .name(std::move(r.name)).charset(std::move(r.charset)).encoding(std::move(r.encoding))
            .contentDisposition(std::move(r.content_disposition)).fileName(std::move(r.filename))
            .cid(std::move(r.cid)).offsetBegin(static_cast<std::size_t>(r.offset_begin))
            .offsetEnd(static_cast<std::size_t>(r.offset_end)).release();
}

inline MimeParts toMime(std::vector<reflection::MimePart> vr) {
    MimeParts mime;
    for (auto& r : vr) {
        mime.push_back(toMimePart(std::move(r)));
    }
    return mime;
}

} // namespace pg
} // namespace macs

#endif /* INCLUDE_INTERNAL_ENVELOPE_MIME_PARTS_H_ */
