#pragma once

#include <internal/envelope/query.h>
#include <pgg/query/ranges.h>
#include <pgg/cast.h>
#include <pgg/range.h>
#include <internal/reflection/revision.h>
#include <internal/query/comment.h>
#include <internal/hooks/wrap.h>

namespace macs{
namespace pg{

struct MoveMessageArgs {
    Mids mids;

    Fid destFid;
    std::optional<Tab::Type> destTab;

    Fid inboxFid;
    TabSet tabs;
};

class TabResolver {
public:
    TabResolver(Fid inboxFid, TabSet tabs)
            : inboxFid_(std::move(inboxFid))
            , tabs_(std::move(tabs)) {}

    std::optional<Tab::Type> operator()(const Fid& fid, const std::optional<Tab::Type>& tab) const {
        if (fid == inboxFid_) {
            if (tab && tabs_.exists(*tab)) {
                return tab;
            }
            if (tabs_.exists(Tab::Type::relevant)) {
                return { Tab::Type::relevant };
            }
        }
        return std::nullopt;
    }

private:
    Fid inboxFid_;
    TabSet tabs_;
};


template <typename TransactionPtr>
void moveMessage(TransactionPtr t, pgg::query::RepositoryPtr qr, Uid uid, pgg::RequestInfo ri,
                 MoveMessageArgs moveArgs, OnUpdate hook) {
    TabResolver tabResolver(std::move(moveArgs.inboxFid), std::move(moveArgs.tabs));
    const auto q = makeQueryWithComment<query::MailboxMoveMessages>(
            *qr, uid, ri,
            query::FolderId(moveArgs.destFid),
            query::OptTabType(tabResolver(moveArgs.destFid, moveArgs.destTab)),
            query::MailIdList(moveArgs.mids));
    t->fetch(q, wrapHook(std::move(hook)));
}

}   //namespace pg
}   //namespace macs
