#pragma once

#include <pgg/query/parameter.h>
#include <macs/queries/envelopes_sorting.h>
#include <internal/label/envelopes_filtering.h>

namespace macs {
namespace pg {
namespace query {

struct __MailBoxOrder{
    typedef SortingType Enum;
    typedef pgg::Enum2String<Enum>::Map Map;
    void fill(Map & map) const {
        map.insert(Map::value_type(SortingType_ascending, "ascending"));
        map.insert(Map::value_type(SortingType_descending, "descending"));
        map.insert(Map::value_type(SortingType_none, "none"));
    }
    typedef __MailBoxOrder Filler;
};

struct __FakeLabelFilter {
    typedef FakeLabel Enum;
    typedef pgg::Enum2String<Enum>::Map Map;
    void fill(Map & map) {
        map.insert(Map::value_type(FakeLabel_attached, "is_attached"));
        map.insert(Map::value_type(FakeLabel_spam, "is_spam"));
        map.insert(Map::value_type(FakeLabel_synced, "is_synced"));
    }
    typedef __FakeLabelFilter Filler;
};

} // namespace query
} // namespace pg
} // namespace macs

PGG_DECLARE_QUERY_PARAMETER((macs)(pg)(query), MailBoxOrder, __MailBoxOrder, SortingType_descending)
PGG_DECLARE_QUERY_PARAMETER((macs)(pg)(query), FakeLabelFilter, __FakeLabelFilter, FakeLabel_attached)

namespace pgg {
namespace query {

/**
 * Helper to use macs::EnvelopesSorting as a query parameter and map it into
 * the pair of the MailBoxSortField and the MailBoxOrder parameters.
 */
template <typename Base>
struct Helper<Base, macs::EnvelopesSorting> {
    Helper() : v(macs::pg::query::MailBoxOrder::defaultValue)
    {}
    void set( macs::EnvelopesSorting arg ) { v = std::move(arg); }
    template <typename MapperT>
    void mapParameter( MapperT m ) const {
        m.mapParameter(macs::pg::query::MailBoxOrder(v.type()));
    }
private :
    macs::EnvelopesSorting v;
};

} // namespace query
} // namespace pgg
