#pragma once

#include <pgg/query/boundaries.h>
#include <pgg/query/ranges.h>
#include <internal/query/ids.h>
#include <internal/query/threads_meta.h>
#include <internal/envelope/orders.h>
#include <internal/envelope/envelope.h>
#include <internal/envelope/mime_parts.h>
#include <internal/mailish/message_info.h>

namespace macs {
namespace pg {
namespace query {

using pgg::query::QueryImpl;
using pgg::query::DateRange;

struct MailboxListOneFolder : QueryImpl<MailboxListOneFolder,
    FolderId, UserId, RowFrom, RowCount, DateRange, macs::EnvelopesSorting> {
    using Inherited::Inherited;
};

struct MailboxListFolders : QueryImpl<MailboxListFolders,
    FolderIdList, UserId, RowFrom, RowCount, DateRange, macs::EnvelopesSorting> {
    using Inherited::Inherited;
};

struct MailboxListLabelReceivedDateSort : QueryImpl< MailboxListLabelReceivedDateSort ,
    UserId, LabelId, RowFrom, RowCount, macs::EnvelopesSorting > {
    using Inherited::Inherited;
};

struct MailboxListAll : QueryImpl< MailboxListAll,
    UserId, RowFrom, RowCount, macs::EnvelopesSorting > {
    using Inherited::Inherited;
};

struct MailboxGetFirstEnvelopeDate : QueryImpl<MailboxGetFirstEnvelopeDate,
    UserId, FolderId > {
    using Inherited::Inherited;
};

struct MailboxGetFirstEnvelopeDateInTab : QueryImpl<MailboxGetFirstEnvelopeDateInTab,
    UserId, TabType > {
    using Inherited::Inherited;
};

struct MailboxListAllWithFakeLabel : QueryImpl<MailboxListAllWithFakeLabel,
    UserId, RowFrom, RowCount, macs::EnvelopesSorting, IsAttachedFilter, IsSpamFilter, IsSyncedFilter > {
    using Inherited::Inherited;
};

struct MailboxListOnlyNew : QueryImpl<MailboxListOnlyNew,
    UserId, RowFrom, RowCount, macs::EnvelopesSorting > {
    using Inherited::Inherited;
};

struct MailboxListNearest : QueryImpl<MailboxListNearest, UserId, MailId, RowCount > {
    using Inherited::Inherited;
};

struct MailboxListFoldersOnlyNew : QueryImpl<MailboxListFoldersOnlyNew,
    FolderIdList, UserId, RowFrom, RowCount, DateRange, macs::EnvelopesSorting > {
    using Inherited::Inherited;
};

struct MailboxListFilterSearch : QueryImpl<MailboxListFilterSearch, UserId, MailIdList,
        FolderIdList, LabelIdList, FilterUnread, FilterAttaches, macs::EnvelopesSorting> {
    using Inherited::Inherited;
};

struct MailboxListByMsgIdWithLabel : QueryImpl<MailboxListByMsgIdWithLabel, UserId,
        MessageId, LabelId > {
    using Inherited::Inherited;
};

struct MailboxListInReplyTo : QueryImpl<MailboxListInReplyTo, UserId, MailReference> {
    using Inherited::Inherited;
};

struct ThreadsView : QueryImpl<ThreadsView,
    FolderId, UserId, RowFrom, RowCount, DateRange > {
    using Inherited::Inherited;
};

struct MailboxListNearestInThread : QueryImpl<MailboxListNearestInThread,
    UserId, MailId, RowCount, macs::EnvelopesSorting > {
    using Inherited::Inherited;
};

struct MailboxListThread : QueryImpl<MailboxListThread,
    UserId, ThreadId, RowFrom, RowCount, macs::EnvelopesSorting > {
    using Inherited::Inherited;
};

struct MailboxListThreadWithLabel : QueryImpl<MailboxListThreadWithLabel,
    UserId, ThreadId, RowFrom, RowCount, LabelId> {
    using Inherited::Inherited;
};

struct MailboxListThreadWithoutLabel : QueryImpl<MailboxListThreadWithoutLabel,
    UserId, ThreadId, RowFrom, RowCount, LabelId> {
    using Inherited::Inherited;
};

struct MailboxEntriesByIds : QueryImpl<MailboxEntriesByIds,
    UserId, MailIdList > {
    using Inherited::Inherited;
};

struct MailboxMoveMessages : QueryImpl<MailboxMoveMessages,
    UserId, pgg::RequestInfo, FolderId, OptTabType, MailIdList > {
    using Inherited::Inherited;
};

struct MailboxEraseMessages : QueryImpl<MailboxEraseMessages,
    UserId, pgg::RequestInfo, MailIdList > {
    using Inherited::Inherited;
};

struct MailboxForceEraseMessages : QueryImpl<MailboxForceEraseMessages,
        UserId, pgg::RequestInfo, MailIdList > {
    using Inherited::Inherited;
};

struct ResetFreshCounter : QueryImpl<ResetFreshCounter, UserId, pgg::RequestInfo> {
    using Inherited::Inherited;
};

struct AddLabels : QueryImpl<AddLabels,
    UserId, pgg::RequestInfo, MailIdList, SetSeen, SetRecent, SetDeleted, LabelIdList> {
    using Inherited::Inherited;
};

struct RemoveLabels : QueryImpl<RemoveLabels,
    UserId, pgg::RequestInfo, MailIdList, SetSeen, SetRecent, SetDeleted, LabelIdList> {
    using Inherited::Inherited;
};

struct AddLabelsByThreads : QueryImpl<AddLabelsByThreads,
    UserId, pgg::RequestInfo, ThreadIdList, SetSeen, SetRecent, SetDeleted, LabelIdList> {
    using Inherited::Inherited;
};

struct RemoveLabelsByThreads : QueryImpl<RemoveLabelsByThreads,
    UserId, pgg::RequestInfo, ThreadIdList, SetSeen, SetRecent, SetDeleted, LabelIdList> {
    using Inherited::Inherited;
};

struct CopyMessages : QueryImpl<CopyMessages, pgg::RequestInfo, UserId, FolderId, MailIds> {
    using Inherited::Inherited;
};

struct ThreadsByTids : QueryImpl< ThreadsByTids, UserId, ThreadIdVector > {
    using Inherited::Inherited;
};

struct ThreadsWithLabel : QueryImpl< ThreadsWithLabel,
    UserId, LabelId, RowFrom, RowCount > {
    using Inherited::Inherited;
};

struct ThreadsInFolderWithoutLabels : QueryImpl< ThreadsInFolderWithoutLabels,
    UserId, FolderId, LabelIdList, RowFrom, RowCount > {
    using Inherited::Inherited;
};

struct ThreadsInFolderWithLabels : QueryImpl< ThreadsInFolderWithLabels,
    UserId, FolderId, LabelIdList, RowFrom, RowCount > {
    using Inherited::Inherited;
};

struct MessagesInFolderWithoutLabels : QueryImpl< MessagesInFolderWithoutLabels,
    UserId, FolderId, LabelIdList, RowFrom, RowCount > {
    using Inherited::Inherited;
};

struct MessagesInFolderWithLabels : QueryImpl< MessagesInFolderWithLabels,
    UserId, FolderId, LabelIdList, RowFrom, RowCount > {
    using Inherited::Inherited;
};

struct StidsByMids : QueryImpl< StidsByMids, UserId, MailIdList > {
    using Inherited::Inherited;
};

struct WindatMessageStId : QueryImpl< WindatMessageStId, UserId, MailId, PartId > {
    using Inherited::Inherited;
};

struct MimesByMids : QueryImpl< MimesByMids, UserId, MailIdList > {
    using Inherited::Inherited;
};

struct MimesWithAttachesByMids : QueryImpl< MimesWithAttachesByMids, UserId, MailIdList > {
    using Inherited::Inherited;
};

struct MimesByMidsWithDeleted : QueryImpl< MimesByMidsWithDeleted, UserId, MailIdList > {
    using Inherited::Inherited;
};

struct MimesWithAttachesByMidsWithDeleted : QueryImpl< MimesWithAttachesByMidsWithDeleted, UserId, MailIdList > {
    using Inherited::Inherited;
};

struct WindatMimesByMids : QueryImpl< WindatMimesByMids, UserId, MailIdList > {
    using Inherited::Inherited;
};

struct MidsByFolder : QueryImpl< MidsByFolder, UserId, FolderId > {
    using Inherited::Inherited;
};

struct MidsRangeByFolder : QueryImpl< MidsRangeByFolder, UserId, FolderId, OptionalMailId, RowCount > {
    using Inherited::Inherited;
};

struct MidsByFolderWithSeen : QueryImpl< MidsByFolderWithSeen, UserId, FolderId, Seen > {
    using Inherited::Inherited;
};

struct MidsRangeByFolderWithSeen : QueryImpl< MidsRangeByFolderWithSeen, UserId, FolderId, Seen, OptionalMailId, RowCount > {
    using Inherited::Inherited;
};

struct MidsByFolderWithoutLabel : QueryImpl< MidsByFolderWithoutLabel,
        UserId, FolderId, LabelId > {
    using Inherited::Inherited;
};

struct MidsRangeByFolderWithoutLabel : QueryImpl< MidsRangeByFolderWithoutLabel,
        UserId, FolderId, LabelId, OptionalMailId, RowCount > {
    using Inherited::Inherited;
};

struct AddToStorageDeleteQueue : QueryImpl< AddToStorageDeleteQueue,
    UserId, StorageId > {
    using Inherited::Inherited;
};

struct StoreMessage : QueryImpl< StoreMessage, UserId, pgg::RequestInfo,
    macs::Envelope, macs::MimeParts, macs::ThreadMeta, QuietFlag, macs::MailishMessageInfoOpt > {
    using Inherited::Inherited;
};

struct QuickSaveMessage : QueryImpl< QuickSaveMessage, UserId, pgg::RequestInfo, macs::Envelope,
    macs::MimeParts > {
    using Inherited::Inherited;
};

struct UpdateMessageAttributes : QueryImpl< UpdateMessageAttributes, UserId, MailId, MailAttributes > {
    using Inherited::Inherited;
};

struct MailboxGetEnvelopesCount : QueryImpl<MailboxGetEnvelopesCount,
        UserId, FolderId, DateRange > {
    using Inherited::Inherited;
};

struct GetMidsByConditions : QueryImpl<GetMidsByConditions,
    UserId, FolderId, Subject, DateRange, From > {
    using Inherited::Inherited;
};

struct GetMidsByConditionsWithSeen : QueryImpl<GetMidsByConditionsWithSeen,
    UserId, FolderId, Subject, DateRange, From, Seen > {
    using Inherited::Inherited;
};

struct GetMidsByConditionsWithoutLabel : QueryImpl<GetMidsByConditionsWithoutLabel,
    UserId, FolderId, Subject, DateRange, From, LabelId> {
    using Inherited::Inherited;
};

struct FindDuplicates : QueryImpl<FindDuplicates,
    UserId, Subject, MessageId, HdrDate> {
    using Inherited::Inherited;
};

struct GetFreshCounter : QueryImpl< GetFreshCounter,
    UserId > {
    using Inherited::Inherited;
};

struct GetAttachesCounters : QueryImpl< GetAttachesCounters,
    UserId > {
    using Inherited::Inherited;
};

struct GetMidsWithoutLabel : QueryImpl<GetMidsWithoutLabel,
    UserId, MailIdList, LabelId> {
    using Inherited::Inherited;
};

struct GetMidsWithSeen : QueryImpl<GetMidsWithSeen, UserId, MailIdList, Seen> {
    using Inherited::Inherited;
};

struct LockUserDelivery : QueryImpl<LockUserDelivery, UserId> {
    using Inherited::Inherited;
};

struct GetByMessageId : QueryImpl<GetByMessageId, UserId, FolderId, MessageId> {
    using Inherited::Inherited;
};

struct GetByMessageIdExceptExcludedFolders : QueryImpl<GetByMessageIdExceptExcludedFolders, UserId, MessageId, FolderIdVector> {
    using Inherited::Inherited;
};

struct GetNewestMessageInThread : QueryImpl<GetNewestMessageInThread, UserId, ThreadId, OutgoingFolders> {
    using Inherited::Inherited;
};

struct GetNotAnsweredMids: QueryImpl<GetNotAnsweredMids, UserId, ThreadId, RemindNoAnswerLid, ReceivedDate> {
    using Inherited::Inherited;
};

struct MessagesInFolderWithMimes : QueryImpl<MessagesInFolderWithMimes,
    UserId, FolderId, RowFrom, RowCount, macs::EnvelopesSorting> {
    using Inherited::Inherited;
};

struct MessagesByMidsWithMimes : QueryImpl<MessagesByMidsWithMimes,
    MailIdList, UserId> {
    using Inherited::Inherited;
};

struct MidsByThreadAndWithSameHeaders : QueryImpl<MidsByThreadAndWithSameHeaders, UserId, ThreadId> {
    using Inherited::Inherited;
};

struct MidsByHdrDateAndMessageIdPairs : QueryImpl<MidsByHdrDateAndMessageIdPairs,
    HdrPairs, UserId> {
    using Inherited::Inherited;
};

struct MessagesInFolderWithMimesByChunks : QueryImpl<MessagesInFolderWithMimesByChunks,
    UserId, FolderId, RangeMin, RangeMax, RowCount> {
    using Inherited::Inherited;
};

struct DeletedMessages : QueryImpl<DeletedMessages,
        UserId, RowFrom, RowCount> {
    using Inherited::Inherited;
};

struct DeletedMessagesInInterval : QueryImpl<DeletedMessagesInInterval,
        UserId, RowFrom, RowCount, DateRange> {
    using Inherited::Inherited;
};

struct DeletedMessagesByIds : QueryImpl<DeletedMessagesByIds,
        UserId, MailIdList > {
    using Inherited::Inherited;
};

struct FindMailishDuplicates : QueryImpl<FindMailishDuplicates, UserId, FolderId, ImapId> {
    using Inherited::Inherited;
};

struct ChangeLabels : QueryImpl<ChangeLabels,
        UserId, pgg::RequestInfo, MailIdList, LabelIdList, OldLabelIdList> {
    using Inherited::Inherited;
};

struct NewMidsInFolderWithoutLabels : QueryImpl<NewMidsInFolderWithoutLabels,
    UserId, FolderId, LabelIdList, RowCount> {
    using Inherited::Inherited;
};

struct NewMidsInFolderWithLabels : QueryImpl<NewMidsInFolderWithLabels,
    UserId, FolderId, LabelIdList, RowCount> {
    using Inherited::Inherited;
};

struct GetMidsByTidsAndLids : QueryImpl<GetMidsByTidsAndLids, UserId, ThreadIdVector, LabelIdVector> {
    using Inherited::Inherited;
};

struct ThreadsInFolderWithoutLabelsForTabs : QueryImpl< ThreadsInFolderWithoutLabelsForTabs,
        UserId, FolderId, LabelIdList, RowFrom, RowCount > {
    using Inherited::Inherited;
};

struct ThreadsInFolderWithLabelsForTabs : QueryImpl< ThreadsInFolderWithLabelsForTabs,
        UserId, FolderId, LabelIdList, RowFrom, RowCount > {
    using Inherited::Inherited;
};

struct MessagesInTab : QueryImpl< MessagesInTab,
        UserId, TabType, RowFrom, RowCount, DateRange > {
    using Inherited::Inherited;
};

struct MessagesInTabOnlyNew : QueryImpl< MessagesInTabOnlyNew,
        UserId, TabType, RowFrom, RowCount, DateRange > {
    using Inherited::Inherited;
};

struct MessagesInTabWithLabels : QueryImpl< MessagesInTabWithLabels,
        UserId, TabType, RowFrom, RowCount, LabelIdVector > {
    using Inherited::Inherited;
};

struct MessagesInTabWithoutLabels : QueryImpl< MessagesInTabWithoutLabels,
        UserId, TabType, RowFrom, RowCount, LabelIdVector > {
    using Inherited::Inherited;
};

struct ThreadsInTab : QueryImpl< ThreadsInTab,
        UserId, TabType, RowFrom, RowCount, DateRange > {
    using Inherited::Inherited;
};

struct ThreadsInTabWithLabels : QueryImpl< ThreadsInTabWithLabels,
        UserId, TabType, RowFrom, RowCount, LabelIdVector > {
    using Inherited::Inherited;
};

struct ThreadsInTabWithoutLabels : QueryImpl< ThreadsInTabWithoutLabels,
        UserId, TabType, RowFrom, RowCount, LabelIdVector > {
    using Inherited::Inherited;
};

struct CountNewMessagesWithLids : QueryImpl< CountNewMessagesWithLids,
        UserId, LabelIdList, RowCount > {
    using Inherited::Inherited;
};

struct MidsByTab : QueryImpl< MidsByTab, UserId, TabType > {
    using Inherited::Inherited;
};

struct MidsByTabWithSeen : QueryImpl< MidsByTabWithSeen, UserId, TabType, Seen > {
    using Inherited::Inherited;
};

struct MidsByTabWithoutLabel : QueryImpl< MidsByTabWithoutLabel,
        UserId, TabType, LabelId > {
    using Inherited::Inherited;
};

struct MidsByLid : QueryImpl< MidsByLid, UserId, LabelId > {
    using Inherited::Inherited;
};

struct MidsWithAttaches : QueryImpl< MidsWithAttaches, UserId > {
    using Inherited::Inherited;
};

struct StoreDeletedMessage : QueryImpl< StoreDeletedMessage, UserId, pgg::RequestInfo,
    macs::EnvelopeDeleted, macs::MimeParts > {
    using Inherited::Inherited;
};

} // namespace query
} // namespace pg
} // namespace macs

