#ifndef INCLUDE_INTERNAL_ENVELOPE_SPAM_DEFENCE_TYPE_H_181430042015
#define INCLUDE_INTERNAL_ENVELOPE_SPAM_DEFENCE_TYPE_H_181430042015

#include <macs/envelope.h>
#include <macs/label_set.h>
#include <boost/range.hpp>
#include <boost/lexical_cast.hpp>

namespace macs {
namespace pg {

inline int typeFromLabel(const Label & label) {
    try {
        return boost::lexical_cast<int>(label.name());
    } catch ( const boost::bad_lexical_cast &) {
        throw std::runtime_error("can not convert label name into type: "
                + label.name());
    }
    return 0;
}

inline const Label & typeToLabel(const LabelSet & set, int type) {
    const std::string t = std::to_string(type);
    auto i = boost::find_if(set, [=](const LabelSet::value_type &v) {
        const auto & label = v.second;
        return label.name() == t && label.type() == Label::Type::spamDefense;
    } );
    if( i == set.end() ) {
        throw std::invalid_argument("unknown spam defence type: " + t);
    }
    return i->second;
}

} // namespace pg
} // namespace macs

#endif /* INCLUDE_INTERNAL_ENVELOPE_SPAM_DEFENCE_TYPE_H_181430042015 */
