#ifndef INCLUDE_INTERNAL_ENVELOPE_STATUS_TO_LABEL_H_184515042015
#define INCLUDE_INTERNAL_ENVELOPE_STATUS_TO_LABEL_H_184515042015

#include <macs/label.h>
#include <macs/label_set.h>
#include <macs/envelope.h>
#include <internal/query/ids.h>

namespace macs {
namespace pg {

inline Label statusToLabel(const LabelSet & labels, Envelope::Status status) {
    using Sym = Label::Symbol;
    Sym symbol(Sym::none);
    switch (status) {
    case Envelope::Status_read:
    case Envelope::Status_unread:
        symbol = Sym::seen_label;
        break;
    case Envelope::Status_replied:
        symbol = Sym::answered_label;
        break;
    case Envelope::Status_forwarded:
        symbol = Sym::forwarded_label;
        break;
    default: {
            std::ostringstream s;
            s << "statusToLabel(): status not supported: " << status;
            throw std::invalid_argument(s.str());
        }
    }
    return labels.at(symbol);
}

inline bool needToAddLabel(Envelope::Status status) {
    return status != Envelope::Status_unread;
}

inline query::Seen seenFromStatus(Envelope::Status status) {
    return query::Seen(status == Envelope::Status_unread);
}


} // namespace pg
} // namespace macs

#endif /* INCLUDE_INTERNAL_ENVELOPE_STATUS_TO_LABEL_H_184515042015 */
